<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rating extends Model 
{

    protected $table = 'ratings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('rating');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function interpreter()
    {
        return $this->belongsTo('App\Models\User');
    }

}